/* Ovaj program osluskuje signale i na temelju njih */
/* cita odredjene podatke s A/D kartice i salje ih  */
/* na FIFO "cjevovod" FIFO_ADC.                     */
/* Prilikom pokretanja, program na FIFO pipe        */
/* salje svoj pid kako bi drugi program npr. deamon */
/* koji posluzuje mail zahtjeve, moga ovom programu */
/* slati odgovarajuce signale.                      */

/* Konkretno program osluskuje signale    USR1, USR2,    */
/* INT i HUP te salje na FIFO_ADC  uzorke    */
/* ovisno o primljenom signalu                       */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <linux/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <asm/user.h>
#include "a2dc.h"
#include "bsd_signal.h"

#define FIFO_FILE	"FIFO_ADC"
#define FIFO_PID	"FIFO_PID"

static void sig_usr(int);  /* deklaracija funkcije za obradu signala */

static void sig_usr(int signo){ /* ova funkcija izvodi obradu signala */
  int fo1,fo4,fod,fdes; 
  WORD buff[1000];
  int n;
  static unsigned char i;

  puts("\nFIFOSERVER: Usao u signal handling funkciju.\n");fflush(stdout);  
	
  if ((fdes=open(FIFO_FILE,O_WRONLY|O_NONBLOCK)) < 0){ /*otvaranje cjevovoda */
  	puts("FIFOSERVER: Pogreska u otvaranju FIFO_ADC.");
	exit(-1);
  }

  switch(signo){
   
    case SIGUSR1:  /* ovaj signal ita 100 vrijednosti sa analognog ulaza 4 */
/* koji je spojen na signal generator */
if ((fo4=open("/dev/das08jr_adc04",O_RDONLY)) < 0){
  	puts("FIFOSERVER: Ne mogu otvoriti adc04 kanal????");
  	puts("FIFOSERVER: Da li je instaliran driver?\n");
  	exit(-1); 
  } 
n=read(fo4,&buff,100);
    printf("\nFIFOSERVER: Procitao n= %d podataka s adc04.\n",n); 
    fflush(stdout);
         
     for(n=0;n<100;n++){  /* ispis proitanih vrijednosti */
     	printf("\nFIFOSERVER: signalgenerator -> buffer_%u = %u",n,buff[n]);
     	fflush(stdout);
     }
     write(fdes,buff,100*sizeof(WORD)); 
     close(fo4);		/* zatvara kanal 4 i cjevovod */
     close(fdes);
    break;

case SIGUSR2:  /* ovaj signal ita 1000 vrijednosti sa analognog ulaza 4 */
/* koji je spojen na signal generator */
if ((fo4=open("/dev/das08jr_adc04",O_RDONLY)) < 0){
  	puts("FIFOSERVER: Ne mogu otvoriti adc04 kanal????");
  	puts("FIFOSERVER: Da li je instaliran driver?\n");
  	exit(-1); 
  } 
n=read(fo4,&buff,1000);
    printf("\nFIFOSERVER: Procitao n= %d podataka s adc04.\n",n); 
    fflush(stdout);
         
     for(n=0;n<1000;n++){  /* ispis proitanih vrijednosti */
     	printf("\nFIFOSERVER: signalgenerator -> buffer_%u = %u",n,buff[n]);
     	fflush(stdout);
     }
     write(fdes,buff,1000*sizeof(WORD)); 
     close(fo4);		/* zatvara kanal 4 i cjevovod */
     close(fdes);
    break;

    case SIGINT:  /* ovaj signal ita 10 vrijednosti sa analognog ulaza 1 */
/* koji je spojen na potenciometar */
if ((fo1=open("/dev/das08jr_adc01",O_RDONLY)) < 0){
  	puts("FIFOSERVER: Ne mogu otvoriti adc01 kanal????");
  	puts("FIFOSERVER: Da li je instaliran driver?\n");
  	exit(-1); 
  } 
    n=read(fo,&buff,10);
    printf("\nFIFOSERVER: Procitao n= %d podataka s adc01.\n",n); 
    fflush(stdout);
         
     for(n=0;n<10;n++){	/* ispis proitanih vrijednosti */
     	printf("\nFIFOSERVER: potenciometar -> buffer_%u = %u",n,buff[n]);
     	fflush(stdout);
     }
     write(fdes,buff,10*sizeof(WORD)); 
     close(fo1);	/* zatvara kanal 1 i cjevovod */
     close(fdes);
    break;

case SIGHUP:  /* ovaj signal ita digitalne ulaze i prikazuje ih na led diode */
if ((fod=open("/dev/das08jr_dio",O_RDWR)) < 0){
  	puts("FIFOSERVER: Ne mogu otvoriti dio????");
  	puts("FIFOSERVER: Da li je instaliran driver?\n");
  	exit(-1); 
  } 
read(fod,&i,1);
write(fod,&i,1);
write(fdes,&i,1);
close(fod);	/* zatvara dio i cjevovod */
close(fdes);
break;

    default:
     /* ovaj dio koda se u biti nikada nece izvrsiti,   */
     /* osim ako je u main funkciji definiran signal    */
     /* handler funkcija za signal, a on nije obuhvacen */
     /* ovim case-om iznad 				                 */
     puts("FIFOSERVER: Ne znam sto bih s ovim signalom?\n");
     break;
 }
     return;
     
}


void main(void){
  	
  	int proces_id,fd;
  	char sp_id[7];
  	  	
  	/* ovaj program za IPC koristi fifo strukture */
  	  	
  	umask(0);  	/* potrebno kako korisnicki file permission */
  		   		/* atributi ne bi sprijecili kreiranje FIFO */
  		   
	mknod(FIFO_FILE,S_IFIFO|0666,0); /* stvaranje imenovanoh cjevovoda */
	mknod(FIFO_PID,S_IFIFO|0666,0);
	
	if((fd=open(FIFO_PID,O_WRONLY)) < 0){
		puts("\nFIFOSERVER: Ne mogu otvoriti FIFO_PID\n");
		fflush(stdout);
		exit(-1);
	}
	proces_id=getpid();
	
	printf("\nFIFOSERVER:\t PID= %d\n",proces_id);fflush(stdout);
	sprintf(sp_id,"%06d",proces_id);
	write(fd,sp_id,7);  /* upisuje pid procesa u fifo da bi fclient znao pid fservera */

  	if (signal(SIGUSR1,sig_usr) == SIG_ERR){ puts("\nNe mogu USR1");exit;}
if (signal(SIGINT,sig_usr) == SIG_ERR){ puts("\nNe mogu INT");exit;}
if (signal(SIGUSR2,sig_usr) == SIG_ERR){ puts("\nNe mogu USR2");exit;} 
if (signal(SIGHUP,sig_usr) == SIG_ERR){ puts("\nNe mogu HUP");exit;}

	while(1);
}