
#define TRUE  1
#define FALSE 0
#define MAX_COUNT 4096

/* #define DEBUG */


#define DAS08_BASE     0x300     /* base adresa - DIP prekidaci */

#ifndef DEFAULT_MAJOR_DEV
#define DEFAULT_MAJOR_DEV  31    /* Default Major Device Number */
#endif

#define AD_CHANNELS         8    /*  8 Diff. A/D kanala            */ 
#define DIO_PORTS           1    /*  dio portovi (zapravo samo 1)  */
#define BOARD_SIZE       0x04    /*  kartica trosi 4 adrese        */


/* I/O registri */

/*     AD_MSB          AD_LSB					   */
/*   11      4        3  0        ---> bitovi A/D rijeci           */ 
/*    xxxxxxxx        xxxxoooo                                     */
/*    7      0        7  4   0                                     */  
/*    registar        registar                                     */
/*    na adresi       na adresi                                    */
/*    DAS08_BASE      DAS08_BASE+1                                 */


#define AD_LSB           (DAS08_BASE)    /* bit 3  - bit 0          */
#define AD_MSB           (DAS08_BASE+1)  /* bit 11 - bit 4          */
#define STAT_MUX         (DAS08_BASE+2)  /* STATUS i MUX registar   */


#define DIO_PORT         (DAS08_BASE+3)  /* digitalni ulaz/izlaz    */

#define EOC   0x80      /* 1=A/D traje ADC, 0=zavrsena ADC  */


/*  ioctl() value */

#define ADC_GET_STATUS      1

/* open mode value */

#define ADC_SOFT_TRIGGER         (0x0)

#define BYTE unsigned char
#define WORD unsigned short
#define LONG unsigned long


 
typedef struct BOARD_REC {
  int  busy;           /* busy = TRUE, free = FALSE                */
  WORD base;           /* Base address of ADC board                */
  BYTE status;         /* Status BYTE                              */
} BoardRec;



typedef struct ADC_CHANNEL_REC {
  int  open;            /* Is channel device open()                 */
  LONG count;           /* Number of samples requested              */
  BYTE mode;            /* 0 =  Soft Trigger                        */
  BYTE chan;            /* Mux number                               */
} ADC_ChanRec;

typedef struct DIO_CHANNEL_REC {
  int  open;              /* Is channel device open()    */
  WORD value;             /* value of DIO Channel        */
  WORD addr;              /* address of the channel      */
  BYTE f_flags;           /* flags sent by open()        */
} DIO_ChanRec;

